package easik.ui.menu;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

import easik.Easik;
import easik.sketch.Sketch;
import easik.states.AddCommutativeDiagramState;
import easik.ui.ApplicationFrame;


/** 
 * Menu action for adding commutative diagrams.
 * 
 * @author Rob Fletcher 2005
 * @author Kevin Green 2006
 * @version 2006-05-23 Kevin Green
 */
public class AddCommutativeDiagramAction extends AbstractAction {
	
	/**
	 * Create the new action and set the name and description
	 */
	public AddCommutativeDiagramAction() {
		super();
		putValue(AbstractAction.NAME, "Add a Commutative Diagram");
		putValue(
			AbstractAction.SHORT_DESCRIPTION,
			"Add a commutative diagram to sketch");
	}

	/**
	 * When action is performed, attempt to create a new commutative diagram.
	 * 
	 * @param e The action event
	 */
	public void actionPerformed(ActionEvent e) {
		if(!Easik.getInstance().getFrame().getSketch().getEntities().isEmpty()){
			Easik.getInstance().getStateManager().pushState(
					new AddCommutativeDiagramState(Easik.getInstance().getFrame().getSketch()));	
		}
		else{
			JOptionPane.showMessageDialog(null, "Sketch cannot be empty.", "Error", JOptionPane.ERROR_MESSAGE);
		}
	}
}
